#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;
int crveni=0;
int plavi=0;
int kostanje=0;
struct cvor
{
    int koji;
    int cost;
    int povezanih;

};

struct Graph
{
    int n;
    vector<vector<int> > adj;
    vector<cvor > v;
    vector<int> boja;
};

void init_graph(Graph &g, int n)
{
    g.n=n;
    g.adj.resize(n);
    g.boja.resize(n,0);
    for(int i=0;i<n;i++)
    {
        int x;
        cin >>x;
        cvor pom;
        pom.koji=i;
        pom.cost=x;
        pom.povezanih=0;
        g.v.push_back(pom);
    }
}

void addEdge(Graph &g,int u,int v)
{
    g.adj[u].push_back(v);
    g.adj[v].push_back(u);
    g.v[u].povezanih++;
    g.v[v].povezanih++;

}

void oboji(Graph &g)
{
    queue<int> q;
    queue<int> color;
    q.push(0);
    color.push(1);
    g.boja[0]=1;
    crveni++;
    kostanje+=g.v[0].cost;
    while(!q.empty())
    {
        int pom=q.front();
        int pomcol=color.front();
        q.pop();
        color.pop();

        for(int i=0;i<g.adj[pom].size();i++)
        {
            if(g.boja[g.adj[pom][i]]==0)
            {
               g.boja[g.adj[pom][i]]=pomcol*(-1);
               if(pomcol==1)
               {
                   plavi++;
               }
               else
               {
                   crveni++;
               }
               q.push(g.adj[pom][i]);
               color.push(pomcol*(-1));
               kostanje+=g.v[g.adj[pom][i]].cost;
            }

        }

    }

}
bool cmp(cvor prvi, cvor drugi)
{
    if(prvi.cost>drugi.cost) return true;
    if(prvi.cost==drugi.cost &&prvi.povezanih<drugi.povezanih) return true;

    return false;
}
void odboji(Graph &g)
{
    sort(g.v.begin(),g.v.end(),cmp);
    for(int i=0;i<g.n;i++)
    {
        int k=g.v[i].koji;
        int t=true;
        for(int j=0;j<g.adj[k].size();j++)
        {
            if(g.boja[g.adj[k][j]]==0)
            {
                t=false;
                break;
            }
        }
        if(t)
        {
            kostanje-=g.v[i].cost;
            if(g.boja[k]==1)
            {
                crveni--;
            }
            else
            {
                plavi--;
            }
            g.boja[k]=0;
        }
    }

}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >>n;
    Graph g;
    init_graph(g,n);
    for(int i=0;i<n-1;i++)
    {
        int u,v;
        cin >>u>>v;
        addEdge(g,u-1,v-1);
    }

    //oboji
    oboji(g);
    /*cout <<crveni<<"\n";
    cout <<plavi<<"\n";
    cout <<kostanje<<"\n";
    */
    //odboji
    odboji(g);
    cout <<kostanje<<"\n";
    cout <<crveni<<"\n";
    if(crveni!=0)
    {

    for(int i=0;i<g.n;i++)
    {
        if(g.boja[i]==1)
        {
            cout <<i+1<<" ";
        }
    }
    cout <<"\n";
    }
    cout <<plavi<<"\n";
    if(plavi!=0)
    {

    for(int i=0;i<g.n;i++)
    {
        if(g.boja[i]==-1)
        {
            cout <<i+1<<" ";
        }
    }
    cout <<"\n";
    }
    return 0;
}